/**
 * \file: AudioSourceChannel.h
 *
 * \version: $Id:$
 *
 * \release: $Name:$
 *
 * <brief description>.
 * <detailed description>
 * \component: Android Auto
 *
 * \author: I. Hayashi / ADITJ/SW / ihayashi@jp.adit-jv.com
 *
 * \copyright (c) 2014-2015 Advanced Driver Information Technology.
 * This code is developed by Advanced Driver Information Technology.
 * Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
 * All rights reserved.
 *
 * \see <related items>
 *
 * \history
 *
 ***********************************************************************/

#ifndef AAUTO_AUDIOSOURCE_CHANNEL_H
#define AAUTO_AUDIOSOURCE_CHANNEL_H

#include <adit_logging.h>
#include "aauto/AautoErrorCodes.h"

/* GalReceiver headers */
#include <aauto/GalReceiver.h>
#include <aauto/util/shared_ptr.h>

#include "aauto/AditAudioSource.h"

#include "utils/IConfiguration.h"

namespace adit { namespace aauto {

class AudioSourceChannel : public IAditAudioSourceCallbacks
{
public:
    AudioSourceChannel(::shared_ptr<GalReceiver> inReceiver, uint8_t inSessionId, IDynamicConfiguration& inConfig);
    ~AudioSourceChannel();

    bool Initialize();
    void shutdown();
    int microphoneRequestCallback(bool open, bool ancEnabled, bool ecEnabled);
    void notifyErrorCallback(aautoErrorCodes inErrorCode);

private:
    ::shared_ptr<GalReceiver> receiver;
    uint8_t sessionId;
    IDynamicConfiguration* mConfig;

    ::shared_ptr<AditAudioSource> endpoint;
};

} } /* namespace adit { namespace aauto */

#endif /* AAUTO_AUDIOSOURCE_CHANNEL_H */
